//
//  MCCollapsibleSheetWidgetDefines.h
//  CollapsibleWidget
//
//  Created by Michael Clark on 12/07/2005.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#pragma mark Widget Defines
#define MCCSWidgetTopMargin         10.0f
#define MCCSWidgetBottomMargin      10.0f
#define MCCSWidgetLeftMargin        10.0f
#define MCCSWidgetRightMargin       10.0f
#define MCCSWidgetVerticalSpacing    8.0f

#pragma mark Internal Widget Margins
#define MCCSWidgetTopInternalMargin          0.0f
#define MCCSWidgetBottomInternalMargin       3.0f
#define MCCSWidgetLeftInternalMargin         3.0f
#define MCCSWidgetRightInternalMargin        3.0f

#pragma mark Header Defines
#define   MCCSWHeaderHeight                 		20.0f
#define   MCCSWHeaderButtonTopMargin         		2.0f
#define   MCCSWHeaderButtonBottomMargin      		2.0f
#define   MCCSWHeaderButtonRightMargin       		3.0f
#define   MCCSWHeaderButtonLeftMargin        		3.0f
#define   MCCSWHeaderTextLeftMargin          		3.0f
#define   MCCSWHeaderTextRightMargin         		3.0f
#define   MCCSWHeaderTextBottomMargin        		6.0f
#define   MCCSWHeaderTextTopMargin           		2.0f
#define   MCCSWHeaderCloseButtonWidth				16.0f
#define   MCCSWHeaderDisclosureButtonWidth       	16.0f
#define	  MCCSWHeaderProgressIndicatorWidth      	16.0f
#define   MCCSWHeaderCloseButtonAreaWidth   (MCCSWHeaderButtonLeftMargin + MCCSWHeaderCloseButtonWidth + MCCSWHeaderTextLeftMargin)
#define   MCCSWHeaderDisclosureButtonAreaWidth (MCCSWHeaderButtonRightMargin + MCCSWHeaderDisclosureButtonWidth + MCCSWHeaderTextRightMargin)
#define   MCCSWHeaderProgressIndicatorAreaWidth (MCCSWHeaderDisclosureButtonWidth + MCCSWHeaderButtonRightMargin + MCCSWHeaderButtonLeftMargin)

extern NSFont*          MCCSWHeaderTextFont;
extern NSDictionary*    MCCSWHeaderTextAttributes;

extern NSColor*         MCCSWHeaderTextColor;

extern NSImage*         MCCSWHeaderBackground[]; // left - middle - right
extern NSImage*         MCCSWHeaderBackgroundGradient[]; // left - middle - right

extern NSImage*         MCCSWDisclosureTriangle[]; // 0 collapsed - 1 expanded
extern NSImage*         MCCSWCloseButton[]; // 0 base - 1 gradient - 2 X


#pragma mark Body Defines
#define   MCCSWSheetRightIndent             4.0f
#define   MCCSWSheetLeftIndent              4.0f
#define   MCCSWSheetBorderLineWidth         1.0f
#define   MCCSWSheetRightMargin            12.0f
#define   MCCSWSheetLeftMargin              6.0f
#define   MCCSWSheetTopMargin              12.0f
#define   MCCSWSheetBottomMargin           12.0f
#define   MCCSWSheetWidthDelta             (MCCSWSheetRightIndent + MCCSWSheetLeftIndent + MCCSWSheetBorderLineWidth + MCCSWSheetBorderLineWidth + MCCSWSheetRightMargin + MCCSWSheetLeftMargin)
#define   MCCSWSheetXOriginOffset          (MCCSWidgetLeftInternalMargin + MCCSWSheetLeftIndent + MCCSWSheetBorderLineWidth + MCCSWSheetLeftMargin)
#define   MCCSWSheetHeightDelta            (MCCSWHeaderHeight + MCCSWSheetTopMargin + MCCSWSheetBottomMargin + MCCSWSheetBorderLineWidth)


extern NSColor*     MCCSWBodyBGColor;
extern NSColor*     MCCSWBodyBorderColor;


#pragma mark Generic Defines
extern NSColor*      MCCSWDefaultColor;

extern NSString*     MCCSWPboardType;

@class MCCollapsibleSheetWidget;
@interface MCCollapsibleSheetWidgetDefines : NSObject {

}

@end

@interface NSObject (MCCSWDragDelegate)
- (void)beginDragForWidget:(MCCollapsibleSheetWidget *)widget event:(NSEvent *)event dragImage:(NSImage *)image;
@end
